# 캐시 메모리

속도가 빠른 장치와 느린 장치에서 속도 차이에 따른 병목 현상을 줄이기 위한 메모리를 말한다.

>ex1) CPU 코어와 메모리 사이의 병목 현상 완화  
>ex2) 웹 브라우저 캐시 파일은, 하드디스크와 웹페이지 사이의 병목 현상을 완화

CPU가 주기억장치에서 저장된 데이터를 읽어올 때, 자주 사용하는 데이터를 캐시 메모리에 저장한 뒤, 다음에 이용할 때 주기억장치가 아닌 캐시 메모리에서 먼저 가져오면서 속도를 향상시킨다.

속도라는 장점을 얻지만, 용량이 적기도 하고 비용이 비싼 점이 있다.


CPU에는 이러한 캐시 메모리가 2~3개 정도 사용된다. (L1, L2, L3 캐시 메모리라고 부른다)

속도와 크기에 따라 분류한 것으로, 일반적으로 L1 캐시부터 먼저 사용된다. (CPU에서 가장 빠르게 접근하고, 여기서 데이터를 찾지 못하면 L2로 감)


**듀얼 코어 프로세서의 캐시 메모리** : 각 코어마다 독립된 L1 캐시 메모리를 가지고, 두 코어가 공유하는 L2 캐시 메모리가 내장됨

만약 L1 캐시가 128kb면, 64kb/64kb로 나누어 64kb에 명령어를 처리하기 직전의 명령어를 임시 저장하고, 나머지 64kb에는 실행 후 명령어를 임시저장한다. (명령어 세트로 구성, I-Cache - D-Cache)

- L1 : CPU 내부에 존재
- L2 : CPU와 RAM 사이에 존재
- L3 : 보통 메인보드에 존재한다고 함
> 캐시 메모리 크기가 작은 이유는, SRAM 가격이 매우 비쌈


**디스크 캐시** : 주기억장치(RAM)와 보조기억장치(하드디스크) 사이에 존재하는 캐시

<br/>

## 캐시 메모리 작동 원리
- 시간 지역성  
    for나 while 같은 반복문에 사용하는 조건 변수처럼 한번 참조된 데이터는 잠시후 또 참조될 가능성이 높음

- 공간 지역성  
    A[0], A[1]과 같은 연속 접근 시, 참조된 데이터 근처에 있는 데이터가 잠시후 또 사용될 가능성이 높음

>이처럼 참조 지역성의 원리가 존재한다.


캐시에 데이터를 저장할 때는, 이러한 참조 지역성(공간)을 최대한 활용하기 위해 해당 데이터뿐만 아니라, 옆 주소의 데이터도 같이 가져와 미래에 쓰일 것을 대비한다.

CPU가 요청한 데이터가 캐시에 있으면 'Cache Hit', 없어서 DRAM에서 가져오면 'Cache Miss'가 발생한다.

<br/>

## 캐시 미스 경우 3가지
1. Cold miss  
    해당 메모리 주소를 처음 불러서 나는 미스

2. Conflict miss  
    캐시 메모리에 A와 B 데이터를 저장해야 하는데, A와 B가 같은 캐시 메모리 주소에 할당되어 있어서 나는 미스 (direct mapped cache에서 많이 발생)

3. Capacity miss  
    캐시 메모리의 공간이 부족해서 나는 미스 (Conflict는 주소 할당 문제, Capacity는 공간 문제)


캐시 크기를 키워서 문제를 해결하려하면, 캐시 접근속도가 느려지고 파워를 많이 먹는 단점이 생김

<br/>

## 캐시 메모리 구조 및 작동 방식  
- **Direct Mapped Cache**

    가장 기본적인 구조로, DRAM의 여러 주소가 캐시 메모리의 한 주소에 대응되는 다대일 방식
    
    <img width="505" alt="스크린샷 2023-01-25 오후 3 53 24" src="https://user-images.githubusercontent.com/70997596/214499583-752eaa05-69ef-4881-b976-14ada9a44599.png">


    현재 그림에서는 메모리 공간이 32개(0000011111)이고, 캐시 메모리 공간은 8개(000111)인 상황

    ex) 00001, 01001, 10001, 11001 메모리 주소는 001 캐시 메모리 주소에 맵핑

    이때 000이 '인덱스 필드', 인덱스 제외한 앞의 나머지(00, 01, 10, 11)를 '태그 필드'라고 한다.

    이처럼 캐시메모리는 인덱스 필드 + 태그 필드 + 데이터 필드로 구성된다.

    간단하고 빠른 장점이 있지만, Conflict Miss가 발생하는 것이 단점이다. 위 사진처럼 같은 색깔의 데이터를 동시에 사용해야 할 때 발생한다.


- **Fully Associative Cache**   
    비어있는 캐시 메모리가 있으면, 마음대로 주소를 저장하는 방식

    저장할 때는 매우 간단하지만, 찾을 때가 문제

    조건이나 규칙이 없어서 특정 캐시 Set 안에 있는 모든 블럭을 한번에 찾아 원하는 데이터가 있는지 검색해야 한다. CAM이라는 특수한 메모리 구조를 사용해야하지만 가격이 매우 비싸다.


- **Set Associative Cache**   
    Direct + Fully 방식이다. 특정 행을 지정하고, 그 행안의 어떤 열이든 비어있을 때 저장하는 방식이다. Direct에 비해 검색 속도는 느리지만, 저장이 빠르고 Fully에 비해 저장이 느린 대신 검색이 빠른 중간형이다.

    실제로 위 두가지보다 나중에 나온 방식이다.


## 출처

https://namu.moe/w/%EC%BA%90%EC%8B%9C%20%EB%A9%94%EB%AA%A8%EB%A6%AC  
https://gyoogle.dev/blog/computer-science/computer-architecture/%EC%BA%90%EC%8B%9C%20%EB%A9%94%EB%AA%A8%EB%A6%AC.html  